%{ 
    Function: plotThemAll
    -Plots all the elements of given deployment.

    Input:
    - set: Deployment set structure
    - data: Deployment data
    - bcCoords: Beacons coordinates

    Output:
    - It generates a figure plot

    Copyright  2020 University of Extremadura (UEx)    
 %}

function plotThemAll(set,data)

   colorH1 = 'b';
   colorH2 = 'g';
   colorH3 = 'r';
        
    if ((set.id == 1) || (set.id == 2))
        
        % Pysics environtment information
        utils_Physics_Part0;
        utils_Physics_Part1;
        utils_Physics_Part2;
        utils_Physics_Part3;
        load("dataPhysics.mat");
        
        % Figure 3D
        fig1=figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off');hold on;
       
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,0);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 1
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,1);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 2
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,2);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 3
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        
         % Beacons coordinate Plot
        [floor1 floor2 floor3] = separeteCoordinatesFloor(set,dataPhysics,data.bcCoords);
        aa = plot3(floor1(:,1),floor1(:,2),floor1(:,3),'*','Color',colorH1,'MarkerSize',8);
        hold on
        bb = plot3(floor2(:,1),floor2(:,2),floor2(:,3),'*','Color',colorH2,'MarkerSize',8);
        hold on
        cc = plot3(floor3(:,1),floor3(:,2),floor3(:,3),'*','Color',colorH3,'MarkerSize',8);
        
        hold on
        
        % Labels
        xlabel("West - East (m)");
        ylabel("South - North (m)");
        zlabel("Height (m)");
        xlim([-5 70]);
        ylim([-5 30]);
        zlim([0 10]);
        %title("Physics department building")
        xticks([-5:5:70]);
        yticks([-5:5:30]);
        zticks([0:5:10]);
        
        
        % Legend
        legend([aa,bb,cc], 'Ground floor','First floor','Second floor','FontSize',15,'FontName', 'Times New Roman');
        view(-20, 15)
        fig1.Renderer = 'Painters'
        daspect([1 1 0.4])
        
        %old_sdf(fig1,'2019_Sensors')
        print(fig1,'-fillpage','figures/Deployment_1.pdf','-dpdf');
        %old_savepdf(fig1,'figures/Deployment_1v2.pdf');
   
    elseif  (set.id == 3)
        
        utils_Physics_Part0;
        utils_Physics_Part1;
        utils_Physics_Part2;
        utils_Physics_Part3; 
        utils_Physics_Part4;
        
        utils_Mathematics_Part0;
        utils_Mathematics_Part1;
        utils_Mathematics_Part2;
        utils_Mathematics_Part3;
        utils_Mathematics_Part4;
        
        load("dataPhysics.mat");
        load("dataMathematics.mat");
        fig1=figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off');hold on;

        % Mathematics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,0);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 1
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,1);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 2
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,2);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 3
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        
        plot3(dataMathematics.pE1(:,1),dataMathematics.pE1(:,2),dataMathematics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        % Pysics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,0);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 1
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,1);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        hold on
        
        % Floor 2
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,2);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        hold on
        
        % Floor 3
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        hold on
        
        plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
         % Beacons coordinate Plot
        [floor1 floor2 floor3] = separeteCoordinatesFloor(set,dataPhysics,data.bcCoords);
        aa = plot3(floor1(:,1),floor1(:,2),floor1(:,3),'*','Color',colorH1,'MarkerSize',8);
        hold on
        bb = plot3(floor2(:,1),floor2(:,2),floor2(:,3),'*','Color',colorH2,'MarkerSize',8);
        hold on
        cc = plot3(floor3(:,1),floor3(:,2),floor3(:,3),'*','Color',colorH3,'MarkerSize',8);
        
        % Labels
        xlabel("West - East (m)")
        ylabel("South - North (m)")
        zlabel("Height (m)")
        xlim([-10 90])
        ylim([-10 100])
        zlim([0 10])
        fig1.Renderer = 'Painters'
        xticks([-10:10:90]);
        yticks([-10:10:100]);
        zticks([0:5:10]);
        
        
        legend([aa,bb,cc], 'Ground floor','First floor','Second floor','FontSize',15,'FontName', 'Times New Roman');
        view(-20, 20)
        fig1.Renderer = 'Painters'
        daspect([1 1 0.4])
        hold off
        
        %old_sdf(fig1,'2019_Sensors')
        print(fig1,'-fillpage','figures/Deployment_3.pdf','-dpdf');
    end
end